(function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const point_1 = __importDefault(require("./point"));
const delaunayguibasstolfi_1 = require("delaunayguibasstolfi");
class Graph {
    constructor() {
        this.adjList = new Map();
    }
    addVertex(p) {
        this.adjList.set(p, new Array());
    }
    addEdge(p1, p2) {
        if (this.adjList.get(p1).indexOf(p2) < 0 &&
            this.adjList.get(p2).indexOf(p1) < 0) {
            this.adjList.get(p1).push(p2);
        }
    }
    removeVertex(p) {
        this.adjList.delete(p);
        for (let [p1, adjVertex] of this.adjList) {
            this.adjList.set(p1, adjVertex.filter(function (p1) {
                return (p1 != p);
            }));
        }
    }
    removeEdge(p1, p2) {
        this.adjList.set(p1, this.adjList.get(p1).filter(function (p) {
            return (p2 != p);
        }));
        this.adjList.set(p2, this.adjList.get(p2).filter(function (p) {
            return (p1 != p);
        }));
    }
    toString() {
        let graphString = "";
        let formatMap = new Map();
        let i = 0;
        for (let vertex of this.adjList.keys()) {
            formatMap.set(vertex, i);
            graphString += i + ": " + vertex.toString() + "\n";
            i++;
        }
        graphString += "#" + "\n";
        for (let [vertex, adjList] of this.adjList) {
            for (let adjVertex of adjList) {
                graphString += formatMap.get(adjVertex) + " " + formatMap.get(vertex) + "\n";
            }
        }
        return graphString;
    }
    createDelaunayTriangulation() {
        let arrVertex = [];
        let graphDelaunay = new Graph();
        for (let point of this.adjList.keys()) {
            arrVertex.push(point);
            graphDelaunay.addVertex(point);
        }
        arrVertex.sort(function (a, b) { if (a.x == b.x)
            return a.y - b.y;
        else
            return a.x - b.x; });
        let arrTriangle = delaunayguibasstolfi_1.delaunay(arrVertex);
        for (let triangle of arrTriangle) {
            let a = new point_1.default(triangle.a.x, triangle.a.y);
            let b = new point_1.default(triangle.b.x, triangle.b.y);
            let c = new point_1.default(triangle.c.x, triangle.c.y);
            for (let vertex of arrVertex) {
                if (vertex.x == a.x && vertex.y == a.y) {
                    a = vertex;
                }
                if (vertex.x == b.x && vertex.y == b.y) {
                    b = vertex;
                }
                if (vertex.x == c.x && vertex.y == c.y) {
                    c = vertex;
                }
            }
            graphDelaunay.addEdge(a, b);
            graphDelaunay.addEdge(b, c);
            graphDelaunay.addEdge(a, c);
        }
        return graphDelaunay;
    }
}
exports.default = Graph;

},{"./point":10,"delaunayguibasstolfi":7}],2:[function(require,module,exports){
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const graph_1 = __importDefault(require("./graph"));
const point_1 = __importDefault(require("./point"));
var graph = new graph_1.default();
var selectedEdges = new Array();
var selectColor = "#FFD300";
var vertexSize = 10;
var vertexColor = "blue";
var edgeColor = "red";
var selectedVertex;
var backgroundImage = document.createElement('img');
var x_guide = 0;
var y_guide = 0;
const c = document.getElementById("myCanvas");
const ctx = c.getContext("2d");
c.addEventListener('mousemove', redraw);
c.addEventListener('click', clickCanvas);
const graphLoader = document.getElementById("graphLoader").addEventListener("change", function () {
    selectedEdges.length = 0;
    selectedVertex = undefined;
    let file = document.querySelector("#graphLoader").files[0];
    var reader = new FileReader();
    reader.addEventListener('load', function () {
        let graphString = reader.result;
        let vertices = graphString.split("\n#")[0];
        let edges = graphString.split("\n#")[1];
        let formatMap = new Map();
        graph = new graph_1.default();
        for (let vertex of vertices.split("\n")) {
            let id = vertex.split(":")[0];
            let pos = vertex.split(":")[1];
            let x = pos.split(",")[0];
            let y = pos.split(",")[1];
            let point = new point_1.default(Number(x), Number(y));
            formatMap.set(Number(id), point);
            graph.addVertex(point);
        }
        for (let edge of edges.slice(1, -1).split("\n")) {
            graph.addEdge(formatMap.get(Number(edge.split(" ")[0])), formatMap.get(Number(edge.split(" ")[1])));
        }
    });
    if (file) {
        reader.readAsBinaryString(file);
    }
});
const clearGraph = document.getElementById("clearGraph").addEventListener("click", function (event) {
    selectedEdges.length = 0;
    selectedVertex = undefined;
    graph = new graph_1.default();
    redraw(event);
});
const downloadGraph = document.getElementById("download").addEventListener("click", function () {
    const element = document.createElement('a');
    element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(graph.toString()));
    element.setAttribute('download', "graph.txt");
    element.style.display = 'none';
    document.body.appendChild(element);
    element.click();
    document.body.removeChild(element);
});
const deleteBackground = document.getElementById("deleteBackground").addEventListener("click", function (event) {
    backgroundImage.src = "";
    redraw(event);
});
const createDelaunay = document.getElementById("createDelaunay").addEventListener("click", function (event) {
    selectedVertex = undefined;
    selectedEdges.length = 0;
    graph = graph.createDelaunayTriangulation();
    redraw(event);
});
const compareDelaunay = document.getElementById("compareDelaunay").addEventListener("click", function (event) {
    selectedVertex = null;
    let graphDelaunay = graph.createDelaunayTriangulation();
    for (let [vertex, adjVertices] of graph.adjList) {
        for (let adjVertex of adjVertices) {
            if (!(graphDelaunay.adjList.get(vertex).indexOf(adjVertex) > -1) &&
                !(graphDelaunay.adjList.get(adjVertex).indexOf(vertex) > -1)) {
                selectedEdges.push([vertex, adjVertex]);
            }
        }
    }
    redraw(event);
});
const compareDelaunayDownload = document.getElementById("compareDelaunayDownload").addEventListener("click", function () {
    selectedVertex = undefined;
    let graphDelaunay = graph.createDelaunayTriangulation();
    let message = "Graph: " + "\n";
    message += graph.toString();
    message += "Delaunay Triangulation: " + "\n";
    message += graphDelaunay.toString();
    let noEGDT = 0;
    let noEG = 0;
    let noDT = 0;
    for (let [, adjVertices] of graph.adjList) {
        noEG += adjVertices.length;
    }
    for (let [, adjVertices] of graphDelaunay.adjList) {
        noDT += adjVertices.length;
    }
    for (let [vertex, adjVertices] of graph.adjList) {
        for (let adjVertex of adjVertices) {
            if (graphDelaunay.adjList.get(vertex).indexOf(adjVertex) > -1 ||
                graphDelaunay.adjList.get(adjVertex).indexOf(vertex) > -1) {
                noEGDT += 1;
            }
        }
    }
    message += "Number of edges in Graph:\n";
    message += noEG + "\n";
    message += "Number of edges in DT:\n";
    message += noDT + "\n";
    message += "Number of Graph edges in DT:\n";
    message += noEGDT + "\n";
    message += "Percentage of Graph edges in DT:\n";
    message += noEGDT / noEG * 100;
    var element = document.createElement('a');
    element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(message));
    element.setAttribute('download', "graphDelaunay.txt");
    element.style.display = 'none';
    document.body.appendChild(element);
    element.click();
    document.body.removeChild(element);
});
let imgLoader = document.getElementById("imgLoader").addEventListener("change", function () {
    let file = document.querySelector('#imgLoader').files[0];
    var reader = new FileReader();
    reader.addEventListener("load", function (event) {
        backgroundImage.src = reader.result;
        setTimeout(() => {
            let ratioW = c.width / backgroundImage.width;
            let ratioH = c.height / backgroundImage.height;
            if (ratioH > ratioW) {
                backgroundImage.height = backgroundImage.height * ratioW;
                backgroundImage.width = c.width;
            }
            else {
                backgroundImage.width = backgroundImage.width * ratioH;
                backgroundImage.height = c.height;
            }
            ctx.drawImage(backgroundImage, c.width / 2 - backgroundImage.width / 2, c.height / 2 - backgroundImage.height / 2, backgroundImage.width, backgroundImage.height);
        }, 0);
    }, false);
    if (file) {
        reader.readAsDataURL(file);
    }
});
const setGrid = document.getElementById("setGrid").addEventListener("click", function (event) {
    let x_input = document.getElementById("x_guide");
    let y_input = document.getElementById("y_guide");
    x_guide = Number(x_input.value);
    y_guide = Number(y_input.value);
    redraw(event);
});
function getMousePos(event) {
    let rect = c.getBoundingClientRect();
    let mousePos = new point_1.default(Math.round(event.clientX - rect.left), Math.round(event.clientY - rect.top));
    return mousePos;
}
function findGuideLinePosition(mousePos) {
    if (x_guide > 0) {
        let resolution_x = c.width / (x_guide + 1);
        mousePos.x = mousePos.x / resolution_x;
        mousePos.x = Math.round(mousePos.x);
        mousePos.x = mousePos.x * resolution_x;
    }
    if (y_guide > 0) {
        let resolution_y = c.width / (y_guide + 1);
        mousePos.y = mousePos.y / resolution_y;
        mousePos.y = Math.round(mousePos.y);
        mousePos.y = mousePos.y * resolution_y;
    }
    return mousePos;
}
function checkInside(v1, v2) {
    if (v1.x > v2.x - vertexSize &&
        v1.x < v2.x + vertexSize &&
        v1.y > v2.y - vertexSize &&
        v1.y < v2.y + vertexSize) {
        return true;
    }
    return false;
}
function redraw(event) {
    ctx.beginPath();
    ctx.clearRect(0, 0, c.width, c.height);
    ctx.fillStyle = "#ff9472";
    ctx.lineWidth = 1;
    let mousePos = getMousePos(event);
    const message = "x: " + mousePos.x + " y: " + mousePos.y + " selected: " + selectedVertex;
    ctx.strokeStyle = "#ff9472";
    if (backgroundImage != undefined) {
        ctx.drawImage(backgroundImage, c.width / 2 - backgroundImage.width / 2, c.height / 2 - backgroundImage.height / 2, backgroundImage.width, backgroundImage.height);
    }
    for (let i = 0; i < x_guide; i++) {
        ctx.beginPath();
        ctx.moveTo(c.width / (x_guide + 1) * (i + 1), 0);
        ctx.lineTo(c.width / (x_guide + 1) * (i + 1), c.height);
        ctx.stroke();
    }
    for (let i = 0; i < y_guide; i++) {
        ctx.beginPath();
        ctx.moveTo(0, c.height / (y_guide + 1) * (i + 1));
        ctx.lineTo(c.width, c.height / (y_guide + 1) * (i + 1));
        ctx.stroke();
    }
    ctx.lineWidth = 3;
    for (const [vertex,] of graph.adjList) {
        for (const adjVertex of graph.adjList.get(vertex)) {
            ctx.beginPath();
            ctx.strokeStyle = edgeColor;
            ctx.moveTo(vertex.x, vertex.y);
            ctx.lineTo(adjVertex.x, adjVertex.y);
            ctx.stroke();
        }
    }
    ctx.strokeStyle = selectColor;
    for (let [x, y] of selectedEdges) {
        ctx.beginPath();
        ctx.moveTo(x.x, x.y);
        ctx.lineTo(y.x, y.y);
        ctx.stroke();
    }
    for (const vertex of graph.adjList.keys()) {
        ctx.fillStyle = vertexColor;
        ctx.fillRect(vertex.x - vertexSize / 2, vertex.y - vertexSize / 2, vertexSize, vertexSize);
    }
    ctx.fillStyle = selectColor;
    if (selectedVertex != null) {
        ctx.fillRect(selectedVertex.x - vertexSize / 2, selectedVertex.y - vertexSize / 2, vertexSize, vertexSize);
    }
}
function clickVertex(event) {
    let mousePos = getMousePos(event);
    let insideOfVertex = false;
    let nextVertex;
    mousePos = findGuideLinePosition(mousePos);
    for (let vertex of graph.adjList.keys()) {
        if (checkInside(vertex, mousePos)) {
            insideOfVertex = true;
            nextVertex = vertex;
        }
    }
    if (insideOfVertex && nextVertex == selectedVertex) {
        selectedVertex = null;
    }
    else if (insideOfVertex) {
        selectedVertex = nextVertex;
    }
    else {
        graph.addVertex(mousePos);
    }
}
function clickEdge(event) {
    if (selectedVertex == null) {
        clickVertex(event);
    }
    else if (!checkInside(selectedVertex, getMousePos(event))) {
        const mousePos = getMousePos(event);
        for (let vertex of graph.adjList.keys()) {
            if (checkInside(vertex, mousePos)) {
                graph.addEdge(vertex, selectedVertex);
            }
        }
    }
}
function removeVertex(event) {
    const mousePos = getMousePos(event);
    let insideOfVertex = false;
    let nextVertex;
    for (let vertex of graph.adjList.keys()) {
        if (checkInside(vertex, mousePos)) {
            insideOfVertex = true;
            nextVertex = vertex;
        }
    }
    if (insideOfVertex) {
        graph.removeVertex(nextVertex);
    }
    if (nextVertex == selectedVertex) {
        selectedVertex = null;
    }
}
function removeEdge(event) {
    if (selectedVertex == null) {
        clickVertex(event);
    }
    else {
        const mousePos = getMousePos(event);
        for (let point of graph.adjList.keys()) {
            if (checkInside(point, mousePos)) {
                graph.removeEdge(point, selectedVertex);
            }
        }
    }
}
function clickCanvas(event) {
    selectedEdges.length = 0;
    if (event.shiftKey && event.ctrlKey) {
        removeEdge(event);
    }
    else if (event.ctrlKey) {
        removeVertex(event);
    }
    else if (event.shiftKey) {
        clickEdge(event);
    }
    else {
        clickVertex(event);
    }
    redraw(event);
}

},{"./graph":1,"./point":10}],3:[function(require,module,exports){
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
const edgeFunctions_1 = require("./edgeFunctions");
const triangle_1 = __importDefault(require("./triangle"));
function inCircleTest(a, b, c, d) {
    let adx = (a.x - d.x), ady = (a.y - d.y), ad = Math.pow(adx, 2) + Math.pow(ady, 2), bdx = (b.x - d.x), bdy = (b.y - d.y), bd = Math.pow(bdx, 2) + Math.pow(bdy, 2), cdx = (c.x - d.x), cdy = (c.y - d.y), cd = Math.pow(cdx, 2) + Math.pow(cdy, 2);
    return (adx * (bdy * cd - bd * cdy)
        - ady * (bdx * cd - bd * cdx)
        + ad * (bdx * cdy - bdy * cdx)) > 0;
}
function ccw(a, b, c) {
    return (a.x * (b.y - c.y)
        - a.y * (b.x - c.x)
        + (b.x * c.y - b.y * c.x)) > 0;
}
function rightOf(x, e) {
    return ccw(x, e.dest, e.org);
}
function leftOf(x, e) {
    return ccw(x, e.org, e.dest);
}
function valid(e, basel) {
    return rightOf(e.dest, basel);
}
function delaunayEdges(s) {
    if (s.length == 2) {
        let a = edgeFunctions_1.makeEdge();
        a.org = s[0];
        a.dest = s[1];
        return [a, a.sym];
    }
    else if (s.length == 3) {
        let a = edgeFunctions_1.makeEdge(), b = edgeFunctions_1.makeEdge();
        a.org = s[0];
        b.org = s[1];
        a.dest = b.org;
        b.dest = s[2];
        edgeFunctions_1.splice(a.sym, b);
        if (ccw(a.org, a.dest, b.dest)) {
            let c = edgeFunctions_1.connect(b, a);
            return [a, b.sym];
        }
        else if (ccw(a.org, b.dest, a.dest)) {
            let c = edgeFunctions_1.connect(b, a);
            return [c.sym, c];
        }
        else {
            return [a, b.sym];
        }
    }
    else {
        let [ldo, ldi] = delaunayEdges(s.slice(0, s.length / 2)), [rdi, rdo] = delaunayEdges(s.slice(s.length / 2));
        do {
            if (leftOf(rdi.org, ldi)) {
                ldi = ldi.lNext;
            }
            else if (rightOf(ldi.org, rdi)) {
                rdi = rdi.rPrev;
            }
            else {
                break;
            }
        } while (true);
        let basel = edgeFunctions_1.connect(rdi.sym, ldi);
        if (ldi.org == ldo.org) {
            ldo = basel.sym;
        }
        if (rdi.org == rdo.org) {
            rdo = basel;
        }
        do {
            let lCand = basel.sym.oNext;
            if (valid(lCand, basel)) {
                while (inCircleTest(basel.dest, basel.org, lCand.dest, lCand.oNext.dest)) {
                    let t = lCand.oNext;
                    edgeFunctions_1.deleteEdge(lCand);
                    lCand = t;
                }
            }
            let rCand = basel.oPrev;
            if (valid(rCand, basel)) {
                while (inCircleTest(basel.dest, basel.org, rCand.dest, rCand.oPrev.dest)) {
                    let t = rCand.oPrev;
                    edgeFunctions_1.deleteEdge(rCand);
                    rCand = t;
                }
            }
            if (!valid(lCand, basel) && !valid(rCand, basel)) {
                break;
            }
            if (!valid(lCand, basel) || valid(rCand, basel) && inCircleTest(lCand.dest, lCand.org, rCand.org, rCand.dest)) {
                basel = edgeFunctions_1.connect(rCand, basel.sym);
            }
            else {
                basel = edgeFunctions_1.connect(basel.sym, lCand.sym);
            }
        } while (true);
        return [ldo, rdo];
    }
}
function delaunay(s) {
    let edgeSearch = new Array();
    let trianglePoint = new Array();
    let delaunayTriangles = new Array();
    let searchIndex = 0;
    let e = delaunayEdges(s)[0];
    while (leftOf(e.oNext.dest, e)) {
        e = e.oNext;
    }
    let next = e;
    do {
        edgeSearch.push(next.sym);
        next.vis = true;
        next = next.lNext;
    } while (next != e);
    while (searchIndex != edgeSearch.length) {
        e = edgeSearch[searchIndex];
        searchIndex++;
        if (!e.vis) {
            next = e;
            do {
                trianglePoint.push(next.org);
                if (!next.sym.vis) {
                    edgeSearch.push(next.sym);
                }
                next.vis = true;
                next = next.lNext;
                if (trianglePoint.length == 3) {
                    delaunayTriangles.push(new triangle_1.default(trianglePoint[0], trianglePoint[1], trianglePoint[2]));
                    trianglePoint.length = 0;
                }
            } while (next != e);
        }
    }
    return delaunayTriangles;
}
exports.default = delaunay;
;

},{"./edgeFunctions":6,"./triangle":8}],4:[function(require,module,exports){
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
const edgeError_1 = __importDefault(require("./edgeError"));
class Edge {
    constructor(org, oNext, rot) {
        this.visited = false;
        this.orgValue = org;
        this.oNextValue = oNext;
        this.rotValue = rot;
    }
    get org() { return edgeError_1.default(this.orgValue); }
    get dest() { return this.sym.org; }
    get rot() { return edgeError_1.default(this.rotValue); }
    get sym() { return this.rot.rot; }
    get rotSym() { return this.rot.sym; }
    get oNext() { return edgeError_1.default(this.oNextValue); }
    get lNext() { return this.rotSym.oNext.rot; }
    get dNext() { return this.sym.oNext.sym; }
    get rNext() { return this.rot.oNext.rotSym; }
    get oPrev() { return this.rot.oNext.rot; }
    get lPrev() { return this.oNext.sym; }
    get dPrev() { return this.rotSym.oNext.rotSym; }
    get rPrev() { return this.sym.oNext; }
    set org(org) { this.orgValue = org; }
    set oNext(oNext) { this.oNextValue = oNext; }
    set rot(rot) { this.rotValue = rot; }
    set dest(dest) { this.sym.org = dest; }
    set vis(b) { this.visited = b; }
    get vis() { return this.visited; }
}
exports.default = Edge;

},{"./edgeError":5}],5:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class EdgeError {
}
function checkUndefined(arg) {
    if (arg === undefined) {
        throw new EdgeError();
    }
    return arg;
}
exports.default = checkUndefined;

},{}],6:[function(require,module,exports){
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
const edge_1 = __importDefault(require("./edge"));
function makeEdge() {
    let e = new edge_1.default();
    let e1 = new edge_1.default();
    let e2 = new edge_1.default();
    let e3 = new edge_1.default();
    e.oNext = e;
    e2.oNext = e2;
    e1.oNext = e3;
    e3.oNext = e1;
    e.rot = e1;
    e1.rot = e2;
    e2.rot = e3;
    e3.rot = e;
    return e;
}
exports.makeEdge = makeEdge;
function splice(a, b) {
    let alpha = a.oNext.rot, beta = b.oNext.rot;
    let swapA = a.oNext, swapBeta = beta.oNext, swapAlpha = alpha.oNext;
    a.oNext = b.oNext;
    b.oNext = swapA;
    alpha.oNext = swapBeta;
    beta.oNext = swapAlpha;
}
exports.splice = splice;
function connect(a, b) {
    let e = makeEdge();
    e.org = a.dest;
    e.dest = b.org;
    splice(e, a.lNext);
    splice(e.sym, b);
    return e;
}
exports.connect = connect;
function deleteEdge(e) {
    splice(e, e.oPrev);
    splice(e.sym, e.sym.oPrev);
}
exports.deleteEdge = deleteEdge;
function swap(e) {
    let a = e.oPrev;
    let b = e.sym.oPrev;
    splice(e, a);
    splice(e.sym, b);
    splice(e, a.lNext);
    splice(e.sym, b.lNext);
    e.org = a.dest;
    e.dest = b.dest;
}
exports.swap = swap;

},{"./edge":4}],7:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var delaunay_1 = require("./delaunay");
exports.delaunay = delaunay_1.default;
var vertex_1 = require("./vertex");
exports.Vertex = vertex_1.default;
var triangle_1 = require("./triangle");
exports.Triangle = triangle_1.default;

},{"./delaunay":3,"./triangle":8,"./vertex":9}],8:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class Triangle {
    constructor(a, b, c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }
}
exports.default = Triangle;

},{}],9:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class Vertex {
    constructor(x, y) {
        this.x = x;
        this.y = y;
    }
}
exports.default = Vertex;

},{}],10:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class Point {
    constructor(x, y) {
        this.x = x;
        this.y = y;
    }
    toString() {
        return this.x + ", " + this.y;
    }
}
exports.default = Point;

},{}]},{},[2]);
